package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  AmazonResourceName,
  UUID,
  SuiteDefinitionVersion,
  String128,
  String256,
  ErrorReason
}
import scala.jdk.CollectionConverters._
final case class GetSuiteRunResponse(
    suiteDefinitionId: Option[UUID] = None,
    suiteDefinitionVersion: Option[SuiteDefinitionVersion] = None,
    suiteRunId: Option[UUID] = None,
    suiteRunArn: Option[AmazonResourceName] = None,
    suiteRunConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration
    ] = None,
    testResult: Option[zio.aws.iotdeviceadvisor.model.TestResult] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    status: Option[zio.aws.iotdeviceadvisor.model.SuiteRunStatus] = None,
    errorReason: Option[ErrorReason] = None,
    tags: Option[Map[String128, String256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse = {
    import GetSuiteRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        suiteRunId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteRunId)
      .optionallyWith(
        suiteRunArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteRunArn)
      .optionallyWith(
        suiteRunConfiguration.map(value => value.buildAwsValue())
      )(_.suiteRunConfiguration)
      .optionallyWith(testResult.map(value => value.buildAwsValue()))(
        _.testResult
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorReason.map(value => ErrorReason.unwrap(value): java.lang.String)
      )(_.errorReason)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.wrap(buildAwsValue())
}
object GetSuiteRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse =
      zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionVersion.map(value => value),
        suiteRunId.map(value => value),
        suiteRunArn.map(value => value),
        suiteRunConfiguration.map(value => value.asEditable),
        testResult.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value),
        errorReason.map(value => value),
        tags.map(value => value)
      )
    def suiteDefinitionId: Option[UUID]
    def suiteDefinitionVersion: Option[SuiteDefinitionVersion]
    def suiteRunId: Option[UUID]
    def suiteRunArn: Option[AmazonResourceName]
    def suiteRunConfiguration
        : Option[zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly]
    def testResult: Option[zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def status: Option[zio.aws.iotdeviceadvisor.model.SuiteRunStatus]
    def errorReason: Option[ErrorReason]
    def tags: Option[Map[String128, String256]]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getSuiteRunId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteRunId", suiteRunId)
    def getSuiteRunArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteRunArn", suiteRunArn)
    def getSuiteRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("suiteRunConfiguration", suiteRunConfiguration)
    def getTestResult: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly
    ] = AwsError.unwrapOptionField("testResult", testResult)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorReason: ZIO[Any, AwsError, ErrorReason] =
      AwsError.unwrapOptionField("errorReason", errorReason)
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
  ) extends zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly {
    override val suiteDefinitionId: Option[UUID] = scala
      .Option(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionVersion: Option[SuiteDefinitionVersion] = scala
      .Option(impl.suiteDefinitionVersion())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionVersion(value)
      )
    override val suiteRunId: Option[UUID] = scala
      .Option(impl.suiteRunId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteRunArn: Option[AmazonResourceName] = scala
      .Option(impl.suiteRunArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
    override val suiteRunConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ] = scala
      .Option(impl.suiteRunConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.wrap(value)
      )
    override val testResult
        : Option[zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly] = scala
      .Option(impl.testResult())
      .map(value => zio.aws.iotdeviceadvisor.model.TestResult.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotdeviceadvisor.model.SuiteRunStatus.wrap(value))
    override val errorReason: Option[ErrorReason] = scala
      .Option(impl.errorReason())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.ErrorReason(value)
      )
    override val tags: Option[Map[String128, String256]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotdeviceadvisor.model.primitives.String128(
              key
            ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteRunResponse
  ): zio.aws.iotdeviceadvisor.model.GetSuiteRunResponse.ReadOnly = new Wrapper(
    impl
  )
}
