package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.{ParallelRun, UUID}
import scala.jdk.CollectionConverters._
final case class SuiteRunConfiguration(
    primaryDevice: zio.aws.iotdeviceadvisor.model.DeviceUnderTest,
    selectedTestList: Optional[Iterable[UUID]] = Optional.Absent,
    parallelRun: Optional[ParallelRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration = {
    import SuiteRunConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
      .builder()
      .primaryDevice(primaryDevice.buildAwsValue())
      .optionallyWith(
        selectedTestList.map(value =>
          value.map { item =>
            UUID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.selectedTestList)
      .optionallyWith(
        parallelRun.map(value => ParallelRun.unwrap(value): java.lang.Boolean)
      )(_.parallelRun)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.wrap(buildAwsValue())
}
object SuiteRunConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration =
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration(
        primaryDevice.asEditable,
        selectedTestList.map(value => value),
        parallelRun.map(value => value)
      )
    def primaryDevice: zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    def selectedTestList: Optional[List[UUID]]
    def parallelRun: Optional[ParallelRun]
    def getPrimaryDevice: ZIO[
      Any,
      Nothing,
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ] = ZIO.succeed(primaryDevice)
    def getSelectedTestList: ZIO[Any, AwsError, List[UUID]] =
      AwsError.unwrapOptionField("selectedTestList", selectedTestList)
    def getParallelRun: ZIO[Any, AwsError, ParallelRun] =
      AwsError.unwrapOptionField("parallelRun", parallelRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
  ) extends zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly {
    override val primaryDevice
        : zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly =
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(impl.primaryDevice())
    override val selectedTestList: Optional[List[UUID]] = zio.aws.core.internal
      .optionalFromNullable(impl.selectedTestList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.primitives.UUID(item)
        }.toList
      )
    override val parallelRun: Optional[ParallelRun] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelRun())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.ParallelRun(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
  ): zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly =
    new Wrapper(impl)
}
