package zio.aws.iotdeviceadvisor.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.iotdeviceadvisor.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.iotdeviceadvisor.model.Status
  ): zio.aws.iotdeviceadvisor.model.Status = value match {
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.PASS =>
      val r = PASS
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.FAIL =>
      val r = FAIL
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.PASS_WITH_WARNINGS =>
      val r = PASS_WITH_WARNINGS
      r
    case software.amazon.awssdk.services.iotdeviceadvisor.model.Status.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object PASS extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.PASS
  }
  case object FAIL extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.FAIL
  }
  case object CANCELED extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.CANCELED
  }
  case object PENDING extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.PENDING
  }
  case object RUNNING extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.RUNNING
  }
  case object STOPPING extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.STOPPING
  }
  case object STOPPED extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.STOPPED
  }
  case object PASS_WITH_WARNINGS extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.PASS_WITH_WARNINGS
  }
  case object ERROR extends zio.aws.iotdeviceadvisor.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.iotdeviceadvisor.model.Status =
      software.amazon.awssdk.services.iotdeviceadvisor.model.Status.ERROR
  }
}
