package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListSuiteDefinitionsResponse(
    suiteDefinitionInformationList: Optional[
      Iterable[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse = {
    import ListSuiteDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
      .builder()
      .optionallyWith(
        suiteDefinitionInformationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suiteDefinitionInformationList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListSuiteDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse =
      zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse(
        suiteDefinitionInformationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suiteDefinitionInformationList: Optional[
      List[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getSuiteDefinitionInformationList: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "suiteDefinitionInformationList",
      suiteDefinitionInformationList
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
  ) extends zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly {
    override val suiteDefinitionInformationList: Optional[
      List[zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionInformationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
  ): zio.aws.iotdeviceadvisor.model.ListSuiteDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
