package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class DeviceUnderTest(
    thingArn: Optional[AmazonResourceName] = Optional.Absent,
    certificateArn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest = {
    import DeviceUnderTest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest
      .builder()
      .optionallyWith(
        thingArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.thingArn)
      .optionallyWith(
        certificateArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(buildAwsValue())
}
object DeviceUnderTest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.DeviceUnderTest =
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest(
        thingArn.map(value => value),
        certificateArn.map(value => value)
      )
    def thingArn: Optional[AmazonResourceName]
    def certificateArn: Optional[AmazonResourceName]
    def getThingArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getCertificateArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest
  ) extends zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly {
    override val thingArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
    override val certificateArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest
  ): zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly = new Wrapper(impl)
}
