package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotdeviceadvisor.model.primitives.{SuiteDefinitionVersion, UUID}
import scala.jdk.CollectionConverters._
final case class GetSuiteDefinitionRequest(
    suiteDefinitionId: UUID,
    suiteDefinitionVersion: Optional[SuiteDefinitionVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest = {
    import GetSuiteDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest
      .builder()
      .suiteDefinitionId(UUID.unwrap(suiteDefinitionId): java.lang.String)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest
      .wrap(buildAwsValue())
}
object GetSuiteDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest =
      zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest(
        suiteDefinitionId,
        suiteDefinitionVersion.map(value => value)
      )
    def suiteDefinitionId: UUID
    def suiteDefinitionVersion: Optional[SuiteDefinitionVersion]
    def getSuiteDefinitionId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(suiteDefinitionId)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest
  ) extends zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest.ReadOnly {
    override val suiteDefinitionId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteDefinitionId())
    override val suiteDefinitionVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest
  ): zio.aws.iotdeviceadvisor.model.GetSuiteDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
