package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotdeviceadvisor.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class StopSuiteRunRequest(
    suiteDefinitionId: UUID,
    suiteRunId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest = {
    import StopSuiteRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest
      .builder()
      .suiteDefinitionId(UUID.unwrap(suiteDefinitionId): java.lang.String)
      .suiteRunId(UUID.unwrap(suiteRunId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest.wrap(buildAwsValue())
}
object StopSuiteRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest =
      zio.aws.iotdeviceadvisor.model
        .StopSuiteRunRequest(suiteDefinitionId, suiteRunId)
    def suiteDefinitionId: UUID
    def suiteRunId: UUID
    def getSuiteDefinitionId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(suiteDefinitionId)
    def getSuiteRunId: ZIO[Any, Nothing, UUID] = ZIO.succeed(suiteRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest
  ) extends zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest.ReadOnly {
    override val suiteDefinitionId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteDefinitionId())
    override val suiteRunId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteRunId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.StopSuiteRunRequest
  ): zio.aws.iotdeviceadvisor.model.StopSuiteRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
