package zio.aws.iotdeviceadvisor.model
import zio.aws.iotdeviceadvisor.model.primitives.{
  SuiteDefinitionName,
  SuiteRunResultCount,
  Timestamp,
  UUID,
  SuiteDefinitionVersion
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SuiteRunInformation(
    suiteDefinitionId: Optional[UUID] = Optional.Absent,
    suiteDefinitionVersion: Optional[SuiteDefinitionVersion] = Optional.Absent,
    suiteDefinitionName: Optional[SuiteDefinitionName] = Optional.Absent,
    suiteRunId: Optional[UUID] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    startedAt: Optional[Timestamp] = Optional.Absent,
    endAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      Optional.Absent,
    passed: Optional[SuiteRunResultCount] = Optional.Absent,
    failed: Optional[SuiteRunResultCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunInformation = {
    import SuiteRunInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunInformation
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        suiteRunId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteRunId)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endAt.map(value => Timestamp.unwrap(value): Instant))(
        _.endAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        passed.map(value => SuiteRunResultCount.unwrap(value): Integer)
      )(_.passed)
      .optionallyWith(
        failed.map(value => SuiteRunResultCount.unwrap(value): Integer)
      )(_.failed)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.SuiteRunInformation.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteRunInformation.wrap(buildAwsValue())
}
object SuiteRunInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.SuiteRunInformation =
      zio.aws.iotdeviceadvisor.model.SuiteRunInformation(
        suiteDefinitionId.map(value => value),
        suiteDefinitionVersion.map(value => value),
        suiteDefinitionName.map(value => value),
        suiteRunId.map(value => value),
        createdAt.map(value => value),
        startedAt.map(value => value),
        endAt.map(value => value),
        status.map(value => value),
        passed.map(value => value),
        failed.map(value => value)
      )
    def suiteDefinitionId: Optional[UUID]
    def suiteDefinitionVersion: Optional[SuiteDefinitionVersion]
    def suiteDefinitionName: Optional[SuiteDefinitionName]
    def suiteRunId: Optional[UUID]
    def createdAt: Optional[Timestamp]
    def startedAt: Optional[Timestamp]
    def endAt: Optional[Timestamp]
    def status: Optional[zio.aws.iotdeviceadvisor.model.SuiteRunStatus]
    def passed: Optional[SuiteRunResultCount]
    def failed: Optional[SuiteRunResultCount]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getSuiteRunId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteRunId", suiteRunId)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endAt", endAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPassed: ZIO[Any, AwsError, SuiteRunResultCount] =
      AwsError.unwrapOptionField("passed", passed)
    def getFailed: ZIO[Any, AwsError, SuiteRunResultCount] =
      AwsError.unwrapOptionField("failed", failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunInformation
  ) extends zio.aws.iotdeviceadvisor.model.SuiteRunInformation.ReadOnly {
    override val suiteDefinitionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionVersion: Optional[SuiteDefinitionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionVersion())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives
            .SuiteDefinitionVersion(value)
        )
    override val suiteDefinitionName: Optional[SuiteDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suiteDefinitionName())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
        )
    override val suiteRunId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.suiteRunId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val startedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val endAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.iotdeviceadvisor.model.SuiteRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotdeviceadvisor.model.SuiteRunStatus.wrap(value))
    override val passed: Optional[SuiteRunResultCount] = zio.aws.core.internal
      .optionalFromNullable(impl.passed())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteRunResultCount(value)
      )
    override val failed: Optional[SuiteRunResultCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteRunResultCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunInformation
  ): zio.aws.iotdeviceadvisor.model.SuiteRunInformation.ReadOnly = new Wrapper(
    impl
  )
}
