package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotdeviceadvisor.model.primitives.{
  Timestamp,
  IntendedForQualificationBoolean,
  SuiteDefinitionName,
  UUID
}
import scala.jdk.CollectionConverters._
final case class SuiteDefinitionInformation(
    suiteDefinitionId: Option[UUID] = None,
    suiteDefinitionName: Option[SuiteDefinitionName] = None,
    defaultDevices: Option[
      Iterable[zio.aws.iotdeviceadvisor.model.DeviceUnderTest]
    ] = None,
    intendedForQualification: Option[IntendedForQualificationBoolean] = None,
    createdAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation = {
    import SuiteDefinitionInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        defaultDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultDevices)
      .optionallyWith(
        intendedForQualification.map(value =>
          IntendedForQualificationBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.intendedForQualification)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation
      .wrap(buildAwsValue())
}
object SuiteDefinitionInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation =
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation(
        suiteDefinitionId.map(value => value),
        suiteDefinitionName.map(value => value),
        defaultDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intendedForQualification.map(value => value),
        createdAt.map(value => value)
      )
    def suiteDefinitionId: Option[UUID]
    def suiteDefinitionName: Option[SuiteDefinitionName]
    def defaultDevices
        : Option[List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]]
    def intendedForQualification: Option[IntendedForQualificationBoolean]
    def createdAt: Option[Timestamp]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getDefaultDevices: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ]] = AwsError.unwrapOptionField("defaultDevices", defaultDevices)
    def getIntendedForQualification
        : ZIO[Any, AwsError, IntendedForQualificationBoolean] = AwsError
      .unwrapOptionField("intendedForQualification", intendedForQualification)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
  ) extends zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly {
    override val suiteDefinitionId: Option[UUID] = scala
      .Option(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionName: Option[SuiteDefinitionName] = scala
      .Option(impl.suiteDefinitionName())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
      )
    override val defaultDevices: Option[
      List[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    ] = scala
      .Option(impl.defaultDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(item)
        }.toList
      )
    override val intendedForQualification
        : Option[IntendedForQualificationBoolean] = scala
      .Option(impl.intendedForQualification())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives
          .IntendedForQualificationBoolean(value)
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteDefinitionInformation
  ): zio.aws.iotdeviceadvisor.model.SuiteDefinitionInformation.ReadOnly =
    new Wrapper(impl)
}
