package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotdeviceadvisor.model.primitives.{
  Warnings,
  Timestamp,
  Failure,
  UUID,
  TestCaseDefinitionName,
  LogUrl
}
import scala.jdk.CollectionConverters._
final case class TestCaseRun(
    testCaseRunId: Option[UUID] = None,
    testCaseDefinitionId: Option[UUID] = None,
    testCaseDefinitionName: Option[TestCaseDefinitionName] = None,
    status: Option[zio.aws.iotdeviceadvisor.model.Status] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    logUrl: Option[LogUrl] = None,
    warnings: Option[Warnings] = None,
    failure: Option[Failure] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun = {
    import TestCaseRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
      .builder()
      .optionallyWith(
        testCaseRunId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.testCaseRunId)
      .optionallyWith(
        testCaseDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.testCaseDefinitionId)
      .optionallyWith(
        testCaseDefinitionName.map(value =>
          TestCaseDefinitionName.unwrap(value): java.lang.String
        )
      )(_.testCaseDefinitionName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        logUrl.map(value => LogUrl.unwrap(value): java.lang.String)
      )(_.logUrl)
      .optionallyWith(
        warnings.map(value => Warnings.unwrap(value): java.lang.String)
      )(_.warnings)
      .optionallyWith(
        failure.map(value => Failure.unwrap(value): java.lang.String)
      )(_.failure)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly =
    zio.aws.iotdeviceadvisor.model.TestCaseRun.wrap(buildAwsValue())
}
object TestCaseRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.TestCaseRun =
      zio.aws.iotdeviceadvisor.model.TestCaseRun(
        testCaseRunId.map(value => value),
        testCaseDefinitionId.map(value => value),
        testCaseDefinitionName.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        logUrl.map(value => value),
        warnings.map(value => value),
        failure.map(value => value)
      )
    def testCaseRunId: Option[UUID]
    def testCaseDefinitionId: Option[UUID]
    def testCaseDefinitionName: Option[TestCaseDefinitionName]
    def status: Option[zio.aws.iotdeviceadvisor.model.Status]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def logUrl: Option[LogUrl]
    def warnings: Option[Warnings]
    def failure: Option[Failure]
    def getTestCaseRunId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("testCaseRunId", testCaseRunId)
    def getTestCaseDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("testCaseDefinitionId", testCaseDefinitionId)
    def getTestCaseDefinitionName: ZIO[Any, AwsError, TestCaseDefinitionName] =
      AwsError.unwrapOptionField(
        "testCaseDefinitionName",
        testCaseDefinitionName
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iotdeviceadvisor.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLogUrl: ZIO[Any, AwsError, LogUrl] =
      AwsError.unwrapOptionField("logUrl", logUrl)
    def getWarnings: ZIO[Any, AwsError, Warnings] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getFailure: ZIO[Any, AwsError, Failure] =
      AwsError.unwrapOptionField("failure", failure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
  ) extends zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly {
    override val testCaseRunId: Option[UUID] = scala
      .Option(impl.testCaseRunId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val testCaseDefinitionId: Option[UUID] = scala
      .Option(impl.testCaseDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val testCaseDefinitionName: Option[TestCaseDefinitionName] = scala
      .Option(impl.testCaseDefinitionName())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.TestCaseDefinitionName(value)
      )
    override val status: Option[zio.aws.iotdeviceadvisor.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.iotdeviceadvisor.model.Status.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val logUrl: Option[LogUrl] = scala
      .Option(impl.logUrl())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.LogUrl(value))
    override val warnings: Option[Warnings] = scala
      .Option(impl.warnings())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Warnings(value))
    override val failure: Option[Failure] = scala
      .Option(impl.failure())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Failure(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun
  ): zio.aws.iotdeviceadvisor.model.TestCaseRun.ReadOnly = new Wrapper(impl)
}
