package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotdeviceadvisor.model.primitives.{
  SuiteDefinitionName,
  Timestamp,
  AmazonResourceName,
  UUID,
  SuiteDefinitionVersion
}
import scala.jdk.CollectionConverters._
final case class UpdateSuiteDefinitionResponse(
    suiteDefinitionId: Option[UUID] = None,
    suiteDefinitionArn: Option[AmazonResourceName] = None,
    suiteDefinitionName: Option[SuiteDefinitionName] = None,
    suiteDefinitionVersion: Option[SuiteDefinitionVersion] = None,
    createdAt: Option[Timestamp] = None,
    lastUpdatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse = {
    import UpdateSuiteDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
      .builder()
      .optionallyWith(
        suiteDefinitionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.suiteDefinitionId)
      .optionallyWith(
        suiteDefinitionArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionArn)
      .optionallyWith(
        suiteDefinitionName.map(value =>
          SuiteDefinitionName.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionName)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly =
    zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
      .wrap(buildAwsValue())
}
object UpdateSuiteDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse =
      zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse(
        suiteDefinitionId.map(value => value),
        suiteDefinitionArn.map(value => value),
        suiteDefinitionName.map(value => value),
        suiteDefinitionVersion.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def suiteDefinitionId: Option[UUID]
    def suiteDefinitionArn: Option[AmazonResourceName]
    def suiteDefinitionName: Option[SuiteDefinitionName]
    def suiteDefinitionVersion: Option[SuiteDefinitionVersion]
    def createdAt: Option[Timestamp]
    def lastUpdatedAt: Option[Timestamp]
    def getSuiteDefinitionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("suiteDefinitionId", suiteDefinitionId)
    def getSuiteDefinitionArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("suiteDefinitionArn", suiteDefinitionArn)
    def getSuiteDefinitionName: ZIO[Any, AwsError, SuiteDefinitionName] =
      AwsError.unwrapOptionField("suiteDefinitionName", suiteDefinitionName)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
  ) extends zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly {
    override val suiteDefinitionId: Option[UUID] = scala
      .Option(impl.suiteDefinitionId())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.UUID(value))
    override val suiteDefinitionArn: Option[AmazonResourceName] = scala
      .Option(impl.suiteDefinitionArn())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.AmazonResourceName(value)
      )
    override val suiteDefinitionName: Option[SuiteDefinitionName] = scala
      .Option(impl.suiteDefinitionName())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionName(value)
      )
    override val suiteDefinitionVersion: Option[SuiteDefinitionVersion] = scala
      .Option(impl.suiteDefinitionVersion())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionVersion(value)
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Option[Timestamp] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iotdeviceadvisor.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
  ): zio.aws.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
