package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestResult(
    groups: Option[Iterable[zio.aws.iotdeviceadvisor.model.GroupResult]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.TestResult = {
    import TestResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestResult
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly =
    zio.aws.iotdeviceadvisor.model.TestResult.wrap(buildAwsValue())
}
object TestResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.TestResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.TestResult =
      zio.aws.iotdeviceadvisor.model.TestResult(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groups
        : Option[List[zio.aws.iotdeviceadvisor.model.GroupResult.ReadOnly]]
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.iotdeviceadvisor.model.GroupResult.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestResult
  ) extends zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly {
    override val groups
        : Option[List[zio.aws.iotdeviceadvisor.model.GroupResult.ReadOnly]] =
      scala
        .Option(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotdeviceadvisor.model.GroupResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.TestResult
  ): zio.aws.iotdeviceadvisor.model.TestResult.ReadOnly = new Wrapper(impl)
}
