package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.{ParallelRun, UUID}
import scala.jdk.CollectionConverters._
final case class SuiteRunConfiguration(
    primaryDevice: Option[zio.aws.iotdeviceadvisor.model.DeviceUnderTest] =
      None,
    selectedTestList: Option[Iterable[UUID]] = None,
    parallelRun: Option[ParallelRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration = {
    import SuiteRunConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
      .builder()
      .optionallyWith(primaryDevice.map(value => value.buildAwsValue()))(
        _.primaryDevice
      )
      .optionallyWith(
        selectedTestList.map(value =>
          value.map { item =>
            UUID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.selectedTestList)
      .optionallyWith(
        parallelRun.map(value => ParallelRun.unwrap(value): java.lang.Boolean)
      )(_.parallelRun)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly =
    zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.wrap(buildAwsValue())
}
object SuiteRunConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration =
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration(
        primaryDevice.map(value => value.asEditable),
        selectedTestList.map(value => value),
        parallelRun.map(value => value)
      )
    def primaryDevice
        : Option[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly]
    def selectedTestList: Option[List[UUID]]
    def parallelRun: Option[ParallelRun]
    def getPrimaryDevice: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly
    ] = AwsError.unwrapOptionField("primaryDevice", primaryDevice)
    def getSelectedTestList: ZIO[Any, AwsError, List[UUID]] =
      AwsError.unwrapOptionField("selectedTestList", selectedTestList)
    def getParallelRun: ZIO[Any, AwsError, ParallelRun] =
      AwsError.unwrapOptionField("parallelRun", parallelRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
  ) extends zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly {
    override val primaryDevice
        : Option[zio.aws.iotdeviceadvisor.model.DeviceUnderTest.ReadOnly] =
      scala
        .Option(impl.primaryDevice())
        .map(value =>
          zio.aws.iotdeviceadvisor.model.DeviceUnderTest.wrap(value)
        )
    override val selectedTestList: Option[List[UUID]] = scala
      .Option(impl.selectedTestList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotdeviceadvisor.model.primitives.UUID(item)
        }.toList
      )
    override val parallelRun: Option[ParallelRun] = scala
      .Option(impl.parallelRun())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.ParallelRun(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration
  ): zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly =
    new Wrapper(impl)
}
