package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.{
  String256,
  String128,
  SuiteDefinitionVersion,
  UUID
}
import scala.jdk.CollectionConverters._
final case class StartSuiteRunRequest(
    suiteDefinitionId: UUID,
    suiteDefinitionVersion: Option[SuiteDefinitionVersion] = None,
    suiteRunConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration
    ] = None,
    tags: Option[Map[String128, String256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest = {
    import StartSuiteRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest
      .builder()
      .suiteDefinitionId(UUID.unwrap(suiteDefinitionId): java.lang.String)
      .optionallyWith(
        suiteDefinitionVersion.map(value =>
          SuiteDefinitionVersion.unwrap(value): java.lang.String
        )
      )(_.suiteDefinitionVersion)
      .optionallyWith(
        suiteRunConfiguration.map(value => value.buildAwsValue())
      )(_.suiteRunConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest.wrap(buildAwsValue())
}
object StartSuiteRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest =
      zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest(
        suiteDefinitionId,
        suiteDefinitionVersion.map(value => value),
        suiteRunConfiguration.map(value => value.asEditable),
        tags.map(value => value)
      )
    def suiteDefinitionId: UUID
    def suiteDefinitionVersion: Option[SuiteDefinitionVersion]
    def suiteRunConfiguration
        : Option[zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly]
    def tags: Option[Map[String128, String256]]
    def getSuiteDefinitionId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(suiteDefinitionId)
    def getSuiteDefinitionVersion: ZIO[Any, AwsError, SuiteDefinitionVersion] =
      AwsError.unwrapOptionField(
        "suiteDefinitionVersion",
        suiteDefinitionVersion
      )
    def getSuiteRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("suiteRunConfiguration", suiteRunConfiguration)
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest
  ) extends zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest.ReadOnly {
    override val suiteDefinitionId: UUID =
      zio.aws.iotdeviceadvisor.model.primitives.UUID(impl.suiteDefinitionId())
    override val suiteDefinitionVersion: Option[SuiteDefinitionVersion] = scala
      .Option(impl.suiteDefinitionVersion())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.primitives.SuiteDefinitionVersion(value)
      )
    override val suiteRunConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.ReadOnly
    ] = scala
      .Option(impl.suiteRunConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteRunConfiguration.wrap(value)
      )
    override val tags: Option[Map[String128, String256]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotdeviceadvisor.model.primitives.String128(
              key
            ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.StartSuiteRunRequest
  ): zio.aws.iotdeviceadvisor.model.StartSuiteRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
