package zio.aws.iotdeviceadvisor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotdeviceadvisor.model.primitives.{String256, String128}
import scala.jdk.CollectionConverters._
final case class CreateSuiteDefinitionRequest(
    suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration
    ] = None,
    tags: Option[Map[String128, String256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest = {
    import CreateSuiteDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
      .builder()
      .optionallyWith(
        suiteDefinitionConfiguration.map(value => value.buildAwsValue())
      )(_.suiteDefinitionConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (String128.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest.ReadOnly =
    zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateSuiteDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest =
      zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest(
        suiteDefinitionConfiguration.map(value => value.asEditable),
        tags.map(value => value)
      )
    def suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ]
    def tags: Option[Map[String128, String256]]
    def getSuiteDefinitionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "suiteDefinitionConfiguration",
      suiteDefinitionConfiguration
    )
    def getTags: ZIO[Any, AwsError, Map[String128, String256]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
  ) extends zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest.ReadOnly {
    override val suiteDefinitionConfiguration: Option[
      zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.ReadOnly
    ] = scala
      .Option(impl.suiteDefinitionConfiguration())
      .map(value =>
        zio.aws.iotdeviceadvisor.model.SuiteDefinitionConfiguration.wrap(value)
      )
    override val tags: Option[Map[String128, String256]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotdeviceadvisor.model.primitives.String128(
              key
            ) -> zio.aws.iotdeviceadvisor.model.primitives.String256(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
  ): zio.aws.iotdeviceadvisor.model.CreateSuiteDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
