package zio.aws.iotanalytics
import zio.aws.iotanalytics.model.primitives.ReprocessingId.Type
import zio.aws.iotanalytics.model.primitives.{
  TagKey,
  S3PathChannelMessage,
  MessagePayload,
  AttributeName
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActivityBatchSize extends Subtype[Int]
    type ActivityBatchSize =
      zio.aws.iotanalytics.model.primitives.ActivityBatchSize.Type
    object ActivityName extends Subtype[String]
    type ActivityName = zio.aws.iotanalytics.model.primitives.ActivityName.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.iotanalytics.model.primitives.AttributeName.Type
    object BucketKeyExpression extends Subtype[String]
    type BucketKeyExpression =
      zio.aws.iotanalytics.model.primitives.BucketKeyExpression.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.iotanalytics.model.primitives.BucketName.Type
    object ChannelArn extends Subtype[String]
    type ChannelArn = zio.aws.iotanalytics.model.primitives.ChannelArn.Type
    object ChannelName extends Subtype[String]
    type ChannelName = zio.aws.iotanalytics.model.primitives.ChannelName.Type
    object ColumnDataType extends Subtype[String]
    type ColumnDataType =
      zio.aws.iotanalytics.model.primitives.ColumnDataType.Type
    object ColumnName extends Subtype[String]
    type ColumnName = zio.aws.iotanalytics.model.primitives.ColumnName.Type
    object DatasetActionName extends Subtype[String]
    type DatasetActionName =
      zio.aws.iotanalytics.model.primitives.DatasetActionName.Type
    object DatasetArn extends Subtype[String]
    type DatasetArn = zio.aws.iotanalytics.model.primitives.DatasetArn.Type
    object DatasetContentVersion extends Subtype[String]
    type DatasetContentVersion =
      zio.aws.iotanalytics.model.primitives.DatasetContentVersion.Type
    object DatasetName extends Subtype[String]
    type DatasetName = zio.aws.iotanalytics.model.primitives.DatasetName.Type
    object DatastoreArn extends Subtype[String]
    type DatastoreArn = zio.aws.iotanalytics.model.primitives.DatastoreArn.Type
    object DatastoreName extends Subtype[String]
    type DatastoreName =
      zio.aws.iotanalytics.model.primitives.DatastoreName.Type
    type DoubleValue = Double
    object EndTime extends Subtype[Instant]
    type EndTime = zio.aws.iotanalytics.model.primitives.EndTime.Type
    object EntryName extends Subtype[String]
    type EntryName = zio.aws.iotanalytics.model.primitives.EntryName.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.iotanalytics.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.iotanalytics.model.primitives.ErrorMessage.Type
    object FilterExpression extends Subtype[String]
    type FilterExpression =
      zio.aws.iotanalytics.model.primitives.FilterExpression.Type
    object GlueDatabaseName extends Subtype[String]
    type GlueDatabaseName =
      zio.aws.iotanalytics.model.primitives.GlueDatabaseName.Type
    object GlueTableName extends Subtype[String]
    type GlueTableName =
      zio.aws.iotanalytics.model.primitives.GlueTableName.Type
    object Image extends Subtype[String]
    type Image = zio.aws.iotanalytics.model.primitives.Image.Type
    object IncludeStatisticsFlag extends Subtype[Boolean]
    type IncludeStatisticsFlag =
      zio.aws.iotanalytics.model.primitives.IncludeStatisticsFlag.Type
    object IotEventsInputName extends Subtype[String]
    type IotEventsInputName =
      zio.aws.iotanalytics.model.primitives.IotEventsInputName.Type
    object LambdaName extends Subtype[String]
    type LambdaName = zio.aws.iotanalytics.model.primitives.LambdaName.Type
    object LateDataRuleName extends Subtype[String]
    type LateDataRuleName =
      zio.aws.iotanalytics.model.primitives.LateDataRuleName.Type
    object LogResult extends Subtype[String]
    type LogResult = zio.aws.iotanalytics.model.primitives.LogResult.Type
    object LoggingEnabled extends Subtype[Boolean]
    type LoggingEnabled =
      zio.aws.iotanalytics.model.primitives.LoggingEnabled.Type
    object MathExpression extends Subtype[String]
    type MathExpression =
      zio.aws.iotanalytics.model.primitives.MathExpression.Type
    object MaxMessages extends Subtype[Int]
    type MaxMessages = zio.aws.iotanalytics.model.primitives.MaxMessages.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotanalytics.model.primitives.MaxResults.Type
    object MaxVersions extends Subtype[Int]
    type MaxVersions = zio.aws.iotanalytics.model.primitives.MaxVersions.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.iotanalytics.model.primitives.MessageId.Type
    object MessagePayload extends Subtype[Chunk[Byte]]
    type MessagePayload =
      zio.aws.iotanalytics.model.primitives.MessagePayload.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iotanalytics.model.primitives.NextToken.Type
    object OffsetSeconds extends Subtype[Int]
    type OffsetSeconds =
      zio.aws.iotanalytics.model.primitives.OffsetSeconds.Type
    object OutputFileName extends Subtype[String]
    type OutputFileName =
      zio.aws.iotanalytics.model.primitives.OutputFileName.Type
    object PartitionAttributeName extends Subtype[String]
    type PartitionAttributeName =
      zio.aws.iotanalytics.model.primitives.PartitionAttributeName.Type
    object PipelineArn extends Subtype[String]
    type PipelineArn = zio.aws.iotanalytics.model.primitives.PipelineArn.Type
    object PipelineName extends Subtype[String]
    type PipelineName = zio.aws.iotanalytics.model.primitives.PipelineName.Type
    object PresignedURI extends Subtype[String]
    type PresignedURI = zio.aws.iotanalytics.model.primitives.PresignedURI.Type
    object Reason extends Subtype[String]
    type Reason = zio.aws.iotanalytics.model.primitives.Reason.Type
    object ReprocessingId extends Subtype[String]
    type ReprocessingId =
      zio.aws.iotanalytics.model.primitives.ReprocessingId.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.iotanalytics.model.primitives.ResourceArn.Type
    object RetentionPeriodInDays extends Subtype[Int]
    type RetentionPeriodInDays =
      zio.aws.iotanalytics.model.primitives.RetentionPeriodInDays.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.iotanalytics.model.primitives.RoleArn.Type
    object S3KeyPrefix extends Subtype[String]
    type S3KeyPrefix = zio.aws.iotanalytics.model.primitives.S3KeyPrefix.Type
    object S3PathChannelMessage extends Subtype[String]
    type S3PathChannelMessage =
      zio.aws.iotanalytics.model.primitives.S3PathChannelMessage.Type
    object ScheduleExpression extends Subtype[String]
    type ScheduleExpression =
      zio.aws.iotanalytics.model.primitives.ScheduleExpression.Type
    object SessionTimeoutInMinutes extends Subtype[Int]
    type SessionTimeoutInMinutes =
      zio.aws.iotanalytics.model.primitives.SessionTimeoutInMinutes.Type
    object SizeInBytes extends Subtype[Double]
    type SizeInBytes = zio.aws.iotanalytics.model.primitives.SizeInBytes.Type
    object SqlQuery extends Subtype[String]
    type SqlQuery = zio.aws.iotanalytics.model.primitives.SqlQuery.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.iotanalytics.model.primitives.StartTime.Type
    object StringValue extends Subtype[String]
    type StringValue = zio.aws.iotanalytics.model.primitives.StringValue.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iotanalytics.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iotanalytics.model.primitives.TagValue.Type
    object TimeExpression extends Subtype[String]
    type TimeExpression =
      zio.aws.iotanalytics.model.primitives.TimeExpression.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iotanalytics.model.primitives.Timestamp.Type
    object TimestampFormat extends Subtype[String]
    type TimestampFormat =
      zio.aws.iotanalytics.model.primitives.TimestampFormat.Type
    object UnlimitedRetentionPeriod extends Subtype[Boolean]
    type UnlimitedRetentionPeriod =
      zio.aws.iotanalytics.model.primitives.UnlimitedRetentionPeriod.Type
    object UnlimitedVersioning extends Subtype[Boolean]
    type UnlimitedVersioning =
      zio.aws.iotanalytics.model.primitives.UnlimitedVersioning.Type
    object VariableName extends Subtype[String]
    type VariableName = zio.aws.iotanalytics.model.primitives.VariableName.Type
    object VolumeSizeInGB extends Subtype[Int]
    type VolumeSizeInGB =
      zio.aws.iotanalytics.model.primitives.VolumeSizeInGB.Type
  }
  type AttributeNameMapping = Map[AttributeName, AttributeName]
  type AttributeNames = List[AttributeName]
  type BatchPutMessageErrorEntries =
    List[zio.aws.iotanalytics.model.BatchPutMessageErrorEntry]
  type ChannelSummaries = List[zio.aws.iotanalytics.model.ChannelSummary]
  type Columns = List[zio.aws.iotanalytics.model.Column]
  type DatasetActionSummaries =
    List[zio.aws.iotanalytics.model.DatasetActionSummary]
  type DatasetActions = List[zio.aws.iotanalytics.model.DatasetAction]
  type DatasetContentDeliveryRules =
    List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule]
  type DatasetContentSummaries =
    List[zio.aws.iotanalytics.model.DatasetContentSummary]
  type DatasetEntries = List[zio.aws.iotanalytics.model.DatasetEntry]
  type DatasetSummaries = List[zio.aws.iotanalytics.model.DatasetSummary]
  type DatasetTriggers = List[zio.aws.iotanalytics.model.DatasetTrigger]
  type DatastoreSummaries = List[zio.aws.iotanalytics.model.DatastoreSummary]
  type LateDataRules = List[zio.aws.iotanalytics.model.LateDataRule]
  type MessagePayloads = List[MessagePayload]
  type Messages = List[zio.aws.iotanalytics.model.Message]
  type Partitions = List[zio.aws.iotanalytics.model.DatastorePartition]
  type PipelineActivities = List[zio.aws.iotanalytics.model.PipelineActivity]
  type PipelineSummaries = List[zio.aws.iotanalytics.model.PipelineSummary]
  type QueryFilters = List[zio.aws.iotanalytics.model.QueryFilter]
  type ReprocessingSummaries =
    List[zio.aws.iotanalytics.model.ReprocessingSummary]
  type S3PathChannelMessages = List[S3PathChannelMessage]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.iotanalytics.model.Tag]
  type Variables = List[zio.aws.iotanalytics.model.Variable]
}
