package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  PipelineArn,
  PipelineName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Pipeline(
    name: Optional[PipelineName] = Optional.Absent,
    arn: Optional[PipelineArn] = Optional.Absent,
    activities: Optional[
      Iterable[zio.aws.iotanalytics.model.PipelineActivity]
    ] = Optional.Absent,
    reprocessingSummaries: Optional[
      Iterable[zio.aws.iotanalytics.model.ReprocessingSummary]
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Pipeline = {
    import Pipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Pipeline
      .builder()
      .optionallyWith(
        name.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        activities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activities)
      .optionallyWith(
        reprocessingSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reprocessingSummaries)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Pipeline.ReadOnly =
    zio.aws.iotanalytics.model.Pipeline.wrap(buildAwsValue())
}
object Pipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Pipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Pipeline =
      zio.aws.iotanalytics.model.Pipeline(
        name.map(value => value),
        arn.map(value => value),
        activities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reprocessingSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def name: Optional[PipelineName]
    def arn: Optional[PipelineArn]
    def activities
        : Optional[List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly]]
    def reprocessingSummaries: Optional[
      List[zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly]
    ]
    def creationTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getActivities: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.PipelineActivity.ReadOnly
    ]] = AwsError.unwrapOptionField("activities", activities)
    def getReprocessingSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("reprocessingSummaries", reprocessingSummaries)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Pipeline
  ) extends zio.aws.iotanalytics.model.Pipeline.ReadOnly {
    override val name: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineName(value))
    override val arn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineArn(value))
    override val activities
        : Optional[List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.PipelineActivity.wrap(item)
          }.toList
        )
    override val reprocessingSummaries: Optional[
      List[zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reprocessingSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.ReprocessingSummary.wrap(item)
        }.toList
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Pipeline
  ): zio.aws.iotanalytics.model.Pipeline.ReadOnly = new Wrapper(impl)
}
