package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.OutputFileName
import scala.jdk.CollectionConverters._
final case class OutputFileUriValue(fileName: OutputFileName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.OutputFileUriValue = {
    import OutputFileUriValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.OutputFileUriValue
      .builder()
      .fileName(OutputFileName.unwrap(fileName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.OutputFileUriValue.ReadOnly =
    zio.aws.iotanalytics.model.OutputFileUriValue.wrap(buildAwsValue())
}
object OutputFileUriValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.OutputFileUriValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.OutputFileUriValue =
      zio.aws.iotanalytics.model.OutputFileUriValue(fileName)
    def fileName: OutputFileName
    def getFileName: ZIO[Any, Nothing, OutputFileName] = ZIO.succeed(fileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.OutputFileUriValue
  ) extends zio.aws.iotanalytics.model.OutputFileUriValue.ReadOnly {
    override val fileName: OutputFileName =
      zio.aws.iotanalytics.model.primitives.OutputFileName(impl.fileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.OutputFileUriValue
  ): zio.aws.iotanalytics.model.OutputFileUriValue.ReadOnly = new Wrapper(impl)
}
