package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.ReprocessingId
import scala.jdk.CollectionConverters._
final case class StartPipelineReprocessingResponse(
    reprocessingId: Optional[ReprocessingId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse = {
    import StartPipelineReprocessingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse
      .builder()
      .optionallyWith(
        reprocessingId.map(value =>
          ReprocessingId.unwrap(value): java.lang.String
        )
      )(_.reprocessingId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly =
    zio.aws.iotanalytics.model.StartPipelineReprocessingResponse
      .wrap(buildAwsValue())
}
object StartPipelineReprocessingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.StartPipelineReprocessingResponse =
      zio.aws.iotanalytics.model
        .StartPipelineReprocessingResponse(reprocessingId.map(value => value))
    def reprocessingId: Optional[ReprocessingId]
    def getReprocessingId: ZIO[Any, AwsError, ReprocessingId] =
      AwsError.unwrapOptionField("reprocessingId", reprocessingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse
  ) extends zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly {
    override val reprocessingId: Optional[ReprocessingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reprocessingId())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.ReprocessingId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.StartPipelineReprocessingResponse
  ): zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly =
    new Wrapper(impl)
}
