package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.ChannelName
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    channelName: ChannelName,
    channelStorage: Optional[zio.aws.iotanalytics.model.ChannelStorage] =
      Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .optionallyWith(channelStorage.map(value => value.buildAwsValue()))(
        _.channelStorage
      )
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.UpdateChannelRequest.ReadOnly =
    zio.aws.iotanalytics.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.UpdateChannelRequest =
      zio.aws.iotanalytics.model.UpdateChannelRequest(
        channelName,
        channelStorage.map(value => value.asEditable),
        retentionPeriod.map(value => value.asEditable)
      )
    def channelName: ChannelName
    def channelStorage
        : Optional[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getChannelStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStorage.ReadOnly
    ] = AwsError.unwrapOptionField("channelStorage", channelStorage)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest
  ) extends zio.aws.iotanalytics.model.UpdateChannelRequest.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
    override val channelStorage
        : Optional[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelStorage())
        .map(value => zio.aws.iotanalytics.model.ChannelStorage.wrap(value))
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdateChannelRequest
  ): zio.aws.iotanalytics.model.UpdateChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
