package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PipelineActivity(
    channel: Optional[zio.aws.iotanalytics.model.ChannelActivity] =
      Optional.Absent,
    lambda: Optional[zio.aws.iotanalytics.model.LambdaActivity] =
      Optional.Absent,
    datastore: Optional[zio.aws.iotanalytics.model.DatastoreActivity] =
      Optional.Absent,
    addAttributes: Optional[zio.aws.iotanalytics.model.AddAttributesActivity] =
      Optional.Absent,
    removeAttributes: Optional[
      zio.aws.iotanalytics.model.RemoveAttributesActivity
    ] = Optional.Absent,
    selectAttributes: Optional[
      zio.aws.iotanalytics.model.SelectAttributesActivity
    ] = Optional.Absent,
    filter: Optional[zio.aws.iotanalytics.model.FilterActivity] =
      Optional.Absent,
    math: Optional[zio.aws.iotanalytics.model.MathActivity] = Optional.Absent,
    deviceRegistryEnrich: Optional[
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity
    ] = Optional.Absent,
    deviceShadowEnrich: Optional[
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.PipelineActivity = {
    import PipelineActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .optionallyWith(datastore.map(value => value.buildAwsValue()))(
        _.datastore
      )
      .optionallyWith(addAttributes.map(value => value.buildAwsValue()))(
        _.addAttributes
      )
      .optionallyWith(removeAttributes.map(value => value.buildAwsValue()))(
        _.removeAttributes
      )
      .optionallyWith(selectAttributes.map(value => value.buildAwsValue()))(
        _.selectAttributes
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(math.map(value => value.buildAwsValue()))(_.math)
      .optionallyWith(deviceRegistryEnrich.map(value => value.buildAwsValue()))(
        _.deviceRegistryEnrich
      )
      .optionallyWith(deviceShadowEnrich.map(value => value.buildAwsValue()))(
        _.deviceShadowEnrich
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.PipelineActivity.ReadOnly =
    zio.aws.iotanalytics.model.PipelineActivity.wrap(buildAwsValue())
}
object PipelineActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.PipelineActivity =
      zio.aws.iotanalytics.model.PipelineActivity(
        channel.map(value => value.asEditable),
        lambda.map(value => value.asEditable),
        datastore.map(value => value.asEditable),
        addAttributes.map(value => value.asEditable),
        removeAttributes.map(value => value.asEditable),
        selectAttributes.map(value => value.asEditable),
        filter.map(value => value.asEditable),
        math.map(value => value.asEditable),
        deviceRegistryEnrich.map(value => value.asEditable),
        deviceShadowEnrich.map(value => value.asEditable)
      )
    def channel: Optional[zio.aws.iotanalytics.model.ChannelActivity.ReadOnly]
    def lambda: Optional[zio.aws.iotanalytics.model.LambdaActivity.ReadOnly]
    def datastore
        : Optional[zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly]
    def addAttributes
        : Optional[zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly]
    def removeAttributes
        : Optional[zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly]
    def selectAttributes
        : Optional[zio.aws.iotanalytics.model.SelectAttributesActivity.ReadOnly]
    def filter: Optional[zio.aws.iotanalytics.model.FilterActivity.ReadOnly]
    def math: Optional[zio.aws.iotanalytics.model.MathActivity.ReadOnly]
    def deviceRegistryEnrich: Optional[
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.ReadOnly
    ]
    def deviceShadowEnrich: Optional[
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly
    ]
    def getChannel: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelActivity.ReadOnly
    ] = AwsError.unwrapOptionField("channel", channel)
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.LambdaActivity.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
    def getDatastore: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly
    ] = AwsError.unwrapOptionField("datastore", datastore)
    def getAddAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly
    ] = AwsError.unwrapOptionField("addAttributes", addAttributes)
    def getRemoveAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly
    ] = AwsError.unwrapOptionField("removeAttributes", removeAttributes)
    def getSelectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.SelectAttributesActivity.ReadOnly
    ] = AwsError.unwrapOptionField("selectAttributes", selectAttributes)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.FilterActivity.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMath
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.MathActivity.ReadOnly] =
      AwsError.unwrapOptionField("math", math)
    def getDeviceRegistryEnrich: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.ReadOnly
    ] = AwsError.unwrapOptionField("deviceRegistryEnrich", deviceRegistryEnrich)
    def getDeviceShadowEnrich: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly
    ] = AwsError.unwrapOptionField("deviceShadowEnrich", deviceShadowEnrich)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
  ) extends zio.aws.iotanalytics.model.PipelineActivity.ReadOnly {
    override val channel
        : Optional[zio.aws.iotanalytics.model.ChannelActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.iotanalytics.model.ChannelActivity.wrap(value))
    override val lambda
        : Optional[zio.aws.iotanalytics.model.LambdaActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambda())
        .map(value => zio.aws.iotanalytics.model.LambdaActivity.wrap(value))
    override val datastore
        : Optional[zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datastore())
        .map(value => zio.aws.iotanalytics.model.DatastoreActivity.wrap(value))
    override val addAttributes
        : Optional[zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addAttributes())
        .map(value =>
          zio.aws.iotanalytics.model.AddAttributesActivity.wrap(value)
        )
    override val removeAttributes: Optional[
      zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removeAttributes())
      .map(value =>
        zio.aws.iotanalytics.model.RemoveAttributesActivity.wrap(value)
      )
    override val selectAttributes: Optional[
      zio.aws.iotanalytics.model.SelectAttributesActivity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.selectAttributes())
      .map(value =>
        zio.aws.iotanalytics.model.SelectAttributesActivity.wrap(value)
      )
    override val filter
        : Optional[zio.aws.iotanalytics.model.FilterActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.iotanalytics.model.FilterActivity.wrap(value))
    override val math
        : Optional[zio.aws.iotanalytics.model.MathActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.math())
        .map(value => zio.aws.iotanalytics.model.MathActivity.wrap(value))
    override val deviceRegistryEnrich: Optional[
      zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceRegistryEnrich())
      .map(value =>
        zio.aws.iotanalytics.model.DeviceRegistryEnrichActivity.wrap(value)
      )
    override val deviceShadowEnrich: Optional[
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceShadowEnrich())
      .map(value =>
        zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.PipelineActivity
  ): zio.aws.iotanalytics.model.PipelineActivity.ReadOnly = new Wrapper(impl)
}
