package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.DatastoreName
import scala.jdk.CollectionConverters._
final case class CreateDatastoreRequest(
    datastoreName: DatastoreName,
    datastoreStorage: Optional[zio.aws.iotanalytics.model.DatastoreStorage] =
      Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotanalytics.model.Tag]] = Optional.Absent,
    fileFormatConfiguration: Optional[
      zio.aws.iotanalytics.model.FileFormatConfiguration
    ] = Optional.Absent,
    datastorePartitions: Optional[
      zio.aws.iotanalytics.model.DatastorePartitions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest = {
    import CreateDatastoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest
      .builder()
      .datastoreName(DatastoreName.unwrap(datastoreName): java.lang.String)
      .optionallyWith(datastoreStorage.map(value => value.buildAwsValue()))(
        _.datastoreStorage
      )
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        fileFormatConfiguration.map(value => value.buildAwsValue())
      )(_.fileFormatConfiguration)
      .optionallyWith(datastorePartitions.map(value => value.buildAwsValue()))(
        _.datastorePartitions
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreateDatastoreRequest.ReadOnly =
    zio.aws.iotanalytics.model.CreateDatastoreRequest.wrap(buildAwsValue())
}
object CreateDatastoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateDatastoreRequest =
      zio.aws.iotanalytics.model.CreateDatastoreRequest(
        datastoreName,
        datastoreStorage.map(value => value.asEditable),
        retentionPeriod.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileFormatConfiguration.map(value => value.asEditable),
        datastorePartitions.map(value => value.asEditable)
      )
    def datastoreName: DatastoreName
    def datastoreStorage
        : Optional[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def tags: Optional[List[zio.aws.iotanalytics.model.Tag.ReadOnly]]
    def fileFormatConfiguration
        : Optional[zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly]
    def datastorePartitions
        : Optional[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly]
    def getDatastoreName: ZIO[Any, Nothing, DatastoreName] =
      ZIO.succeed(datastoreName)
    def getDatastoreStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly
    ] = AwsError.unwrapOptionField("datastoreStorage", datastoreStorage)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fileFormatConfiguration",
      fileFormatConfiguration
    )
    def getDatastorePartitions: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly
    ] = AwsError.unwrapOptionField("datastorePartitions", datastorePartitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest
  ) extends zio.aws.iotanalytics.model.CreateDatastoreRequest.ReadOnly {
    override val datastoreName: DatastoreName =
      zio.aws.iotanalytics.model.primitives.DatastoreName(impl.datastoreName())
    override val datastoreStorage
        : Optional[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datastoreStorage())
        .map(value => zio.aws.iotanalytics.model.DatastoreStorage.wrap(value))
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val tags: Optional[List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.Tag.wrap(item)
          }.toList
        )
    override val fileFormatConfiguration: Optional[
      zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileFormatConfiguration())
      .map(value =>
        zio.aws.iotanalytics.model.FileFormatConfiguration.wrap(value)
      )
    override val datastorePartitions
        : Optional[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datastorePartitions())
        .map(value =>
          zio.aws.iotanalytics.model.DatastorePartitions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreRequest
  ): zio.aws.iotanalytics.model.CreateDatastoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
