package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{MessagePayload, MessageId}
import scala.jdk.CollectionConverters._
final case class Message(messageId: MessageId, payload: MessagePayload) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Message
      .builder()
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .payload(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(payload.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Message.ReadOnly =
    zio.aws.iotanalytics.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Message
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Message =
      zio.aws.iotanalytics.model.Message(messageId, payload)
    def messageId: MessageId
    def payload: MessagePayload
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getPayload: ZIO[Any, Nothing, MessagePayload] = ZIO.succeed(payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Message
  ) extends zio.aws.iotanalytics.model.Message.ReadOnly {
    override val messageId: MessageId =
      zio.aws.iotanalytics.model.primitives.MessageId(impl.messageId())
    override val payload: MessagePayload = zio.aws.iotanalytics.model.primitives
      .MessagePayload(zio.Chunk.fromArray(impl.payload().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Message
  ): zio.aws.iotanalytics.model.Message.ReadOnly = new Wrapper(impl)
}
