package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  MaxResults,
  NextToken,
  DatasetName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetContentsRequest(
    datasetName: DatasetName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    scheduledOnOrAfter: Optional[Timestamp] = Optional.Absent,
    scheduledBefore: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest = {
    import ListDatasetContentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        scheduledOnOrAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledOnOrAfter)
      .optionallyWith(
        scheduledBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledBefore)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.ListDatasetContentsRequest.ReadOnly =
    zio.aws.iotanalytics.model.ListDatasetContentsRequest.wrap(buildAwsValue())
}
object ListDatasetContentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListDatasetContentsRequest =
      zio.aws.iotanalytics.model.ListDatasetContentsRequest(
        datasetName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        scheduledOnOrAfter.map(value => value),
        scheduledBefore.map(value => value)
      )
    def datasetName: DatasetName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def scheduledOnOrAfter: Optional[Timestamp]
    def scheduledBefore: Optional[Timestamp]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getScheduledOnOrAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledOnOrAfter", scheduledOnOrAfter)
    def getScheduledBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledBefore", scheduledBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
  ) extends zio.aws.iotanalytics.model.ListDatasetContentsRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotanalytics.model.primitives.MaxResults(value))
    override val scheduledOnOrAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledOnOrAfter())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val scheduledBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledBefore())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest
  ): zio.aws.iotanalytics.model.ListDatasetContentsRequest.ReadOnly =
    new Wrapper(impl)
}
