package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDatasetResponse(
    dataset: Optional[zio.aws.iotanalytics.model.Dataset] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(dataset.map(value => value.buildAwsValue()))(_.dataset)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.iotanalytics.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeDatasetResponse =
      zio.aws.iotanalytics.model
        .DescribeDatasetResponse(dataset.map(value => value.asEditable))
    def dataset: Optional[zio.aws.iotanalytics.model.Dataset.ReadOnly]
    def getDataset
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Dataset.ReadOnly] =
      AwsError.unwrapOptionField("dataset", dataset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse
  ) extends zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly {
    override val dataset
        : Optional[zio.aws.iotanalytics.model.Dataset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataset())
        .map(value => zio.aws.iotanalytics.model.Dataset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatasetResponse
  ): zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
