package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetContentDeliveryDestination(
    iotEventsDestinationConfiguration: Optional[
      zio.aws.iotanalytics.model.IotEventsDestinationConfiguration
    ] = Optional.Absent,
    s3DestinationConfiguration: Optional[
      zio.aws.iotanalytics.model.S3DestinationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryDestination = {
    import DatasetContentDeliveryDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryDestination
      .builder()
      .optionallyWith(
        iotEventsDestinationConfiguration.map(value => value.buildAwsValue())
      )(_.iotEventsDestinationConfiguration)
      .optionallyWith(
        s3DestinationConfiguration.map(value => value.buildAwsValue())
      )(_.s3DestinationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DatasetContentDeliveryDestination.ReadOnly =
    zio.aws.iotanalytics.model.DatasetContentDeliveryDestination
      .wrap(buildAwsValue())
}
object DatasetContentDeliveryDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.DatasetContentDeliveryDestination =
      zio.aws.iotanalytics.model.DatasetContentDeliveryDestination(
        iotEventsDestinationConfiguration.map(value => value.asEditable),
        s3DestinationConfiguration.map(value => value.asEditable)
      )
    def iotEventsDestinationConfiguration: Optional[
      zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.ReadOnly
    ]
    def s3DestinationConfiguration: Optional[
      zio.aws.iotanalytics.model.S3DestinationConfiguration.ReadOnly
    ]
    def getIotEventsDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "iotEventsDestinationConfiguration",
      iotEventsDestinationConfiguration
    )
    def getS3DestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.S3DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3DestinationConfiguration",
      s3DestinationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryDestination
  ) extends zio.aws.iotanalytics.model.DatasetContentDeliveryDestination.ReadOnly {
    override val iotEventsDestinationConfiguration: Optional[
      zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iotEventsDestinationConfiguration())
      .map(value =>
        zio.aws.iotanalytics.model.IotEventsDestinationConfiguration.wrap(value)
      )
    override val s3DestinationConfiguration: Optional[
      zio.aws.iotanalytics.model.S3DestinationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3DestinationConfiguration())
      .map(value =>
        zio.aws.iotanalytics.model.S3DestinationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryDestination
  ): zio.aws.iotanalytics.model.DatasetContentDeliveryDestination.ReadOnly =
    new Wrapper(impl)
}
