package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.ChannelName
import scala.jdk.CollectionConverters._
final case class BatchPutMessageRequest(
    channelName: ChannelName,
    messages: Iterable[zio.aws.iotanalytics.model.Message]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest = {
    import BatchPutMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .messages(messages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.BatchPutMessageRequest.ReadOnly =
    zio.aws.iotanalytics.model.BatchPutMessageRequest.wrap(buildAwsValue())
}
object BatchPutMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.BatchPutMessageRequest =
      zio.aws.iotanalytics.model.BatchPutMessageRequest(
        channelName,
        messages.map { item =>
          item.asEditable
        }
      )
    def channelName: ChannelName
    def messages: List[zio.aws.iotanalytics.model.Message.ReadOnly]
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getMessages
        : ZIO[Any, Nothing, List[zio.aws.iotanalytics.model.Message.ReadOnly]] =
      ZIO.succeed(messages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest
  ) extends zio.aws.iotanalytics.model.BatchPutMessageRequest.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
    override val messages: List[zio.aws.iotanalytics.model.Message.ReadOnly] =
      impl
        .messages()
        .asScala
        .map { item =>
          zio.aws.iotanalytics.model.Message.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageRequest
  ): zio.aws.iotanalytics.model.BatchPutMessageRequest.ReadOnly = new Wrapper(
    impl
  )
}
