package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{
  IncludeStatisticsFlag,
  DatastoreName
}
import scala.jdk.CollectionConverters._
final case class DescribeDatastoreRequest(
    datastoreName: DatastoreName,
    includeStatistics: Optional[IncludeStatisticsFlag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest = {
    import DescribeDatastoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest
      .builder()
      .datastoreName(DatastoreName.unwrap(datastoreName): java.lang.String)
      .optionallyWith(
        includeStatistics.map(value =>
          IncludeStatisticsFlag.unwrap(value): java.lang.Boolean
        )
      )(_.includeStatistics)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribeDatastoreRequest.ReadOnly =
    zio.aws.iotanalytics.model.DescribeDatastoreRequest.wrap(buildAwsValue())
}
object DescribeDatastoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeDatastoreRequest =
      zio.aws.iotanalytics.model.DescribeDatastoreRequest(
        datastoreName,
        includeStatistics.map(value => value)
      )
    def datastoreName: DatastoreName
    def includeStatistics: Optional[IncludeStatisticsFlag]
    def getDatastoreName: ZIO[Any, Nothing, DatastoreName] =
      ZIO.succeed(datastoreName)
    def getIncludeStatistics: ZIO[Any, AwsError, IncludeStatisticsFlag] =
      AwsError.unwrapOptionField("includeStatistics", includeStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest
  ) extends zio.aws.iotanalytics.model.DescribeDatastoreRequest.ReadOnly {
    override val datastoreName: DatastoreName =
      zio.aws.iotanalytics.model.primitives.DatastoreName(impl.datastoreName())
    override val includeStatistics: Optional[IncludeStatisticsFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeStatistics())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.IncludeStatisticsFlag(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeDatastoreRequest
  ): zio.aws.iotanalytics.model.DescribeDatastoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
