package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.ChannelName
import scala.jdk.CollectionConverters._
final case class DeleteChannelRequest(channelName: ChannelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest = {
    import DeleteChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DeleteChannelRequest.ReadOnly =
    zio.aws.iotanalytics.model.DeleteChannelRequest.wrap(buildAwsValue())
}
object DeleteChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DeleteChannelRequest =
      zio.aws.iotanalytics.model.DeleteChannelRequest(channelName)
    def channelName: ChannelName
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest
  ) extends zio.aws.iotanalytics.model.DeleteChannelRequest.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeleteChannelRequest
  ): zio.aws.iotanalytics.model.DeleteChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
