package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelStorage(
    serviceManagedS3: Optional[
      zio.aws.iotanalytics.model.ServiceManagedChannelS3Storage
    ] = Optional.Absent,
    customerManagedS3: Optional[
      zio.aws.iotanalytics.model.CustomerManagedChannelS3Storage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ChannelStorage = {
    import ChannelStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ChannelStorage
      .builder()
      .optionallyWith(serviceManagedS3.map(value => value.buildAwsValue()))(
        _.serviceManagedS3
      )
      .optionallyWith(customerManagedS3.map(value => value.buildAwsValue()))(
        _.customerManagedS3
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ChannelStorage.ReadOnly =
    zio.aws.iotanalytics.model.ChannelStorage.wrap(buildAwsValue())
}
object ChannelStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ChannelStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ChannelStorage =
      zio.aws.iotanalytics.model.ChannelStorage(
        serviceManagedS3.map(value => value.asEditable),
        customerManagedS3.map(value => value.asEditable)
      )
    def serviceManagedS3: Optional[
      zio.aws.iotanalytics.model.ServiceManagedChannelS3Storage.ReadOnly
    ]
    def customerManagedS3: Optional[
      zio.aws.iotanalytics.model.CustomerManagedChannelS3Storage.ReadOnly
    ]
    def getServiceManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ServiceManagedChannelS3Storage.ReadOnly
    ] = AwsError.unwrapOptionField("serviceManagedS3", serviceManagedS3)
    def getCustomerManagedS3: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.CustomerManagedChannelS3Storage.ReadOnly
    ] = AwsError.unwrapOptionField("customerManagedS3", customerManagedS3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelStorage
  ) extends zio.aws.iotanalytics.model.ChannelStorage.ReadOnly {
    override val serviceManagedS3: Optional[
      zio.aws.iotanalytics.model.ServiceManagedChannelS3Storage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.ServiceManagedChannelS3Storage.wrap(value)
      )
    override val customerManagedS3: Optional[
      zio.aws.iotanalytics.model.CustomerManagedChannelS3Storage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManagedS3())
      .map(value =>
        zio.aws.iotanalytics.model.CustomerManagedChannelS3Storage.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelStorage
  ): zio.aws.iotanalytics.model.ChannelStorage.ReadOnly = new Wrapper(impl)
}
