package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListDatasetContentsResponse(
    datasetContentSummaries: Optional[
      Iterable[zio.aws.iotanalytics.model.DatasetContentSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse = {
    import ListDatasetContentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse
      .builder()
      .optionallyWith(
        datasetContentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetContentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly =
    zio.aws.iotanalytics.model.ListDatasetContentsResponse.wrap(buildAwsValue())
}
object ListDatasetContentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListDatasetContentsResponse =
      zio.aws.iotanalytics.model.ListDatasetContentsResponse(
        datasetContentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetContentSummaries: Optional[
      List[zio.aws.iotanalytics.model.DatasetContentSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getDatasetContentSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetContentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "datasetContentSummaries",
      datasetContentSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse
  ) extends zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly {
    override val datasetContentSummaries: Optional[
      List[zio.aws.iotanalytics.model.DatasetContentSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetContentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.DatasetContentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse
  ): zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly =
    new Wrapper(impl)
}
