package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{Timestamp, DatastoreName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DatastoreSummary(
    datastoreName: Optional[DatastoreName] = Optional.Absent,
    datastoreStorage: Optional[
      zio.aws.iotanalytics.model.DatastoreStorageSummary
    ] = Optional.Absent,
    status: Optional[zio.aws.iotanalytics.model.DatastoreStatus] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent,
    lastMessageArrivalTime: Optional[Timestamp] = Optional.Absent,
    fileFormatType: Optional[zio.aws.iotanalytics.model.FileFormatType] =
      Optional.Absent,
    datastorePartitions: Optional[
      zio.aws.iotanalytics.model.DatastorePartitions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary = {
    import DatastoreSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
      .builder()
      .optionallyWith(
        datastoreName.map(value =>
          DatastoreName.unwrap(value): java.lang.String
        )
      )(_.datastoreName)
      .optionallyWith(datastoreStorage.map(value => value.buildAwsValue()))(
        _.datastoreStorage
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .optionallyWith(fileFormatType.map(value => value.unwrap))(
        _.fileFormatType
      )
      .optionallyWith(datastorePartitions.map(value => value.buildAwsValue()))(
        _.datastorePartitions
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreSummary.wrap(buildAwsValue())
}
object DatastoreSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastoreSummary =
      zio.aws.iotanalytics.model.DatastoreSummary(
        datastoreName.map(value => value),
        datastoreStorage.map(value => value.asEditable),
        status.map(value => value),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value),
        fileFormatType.map(value => value),
        datastorePartitions.map(value => value.asEditable)
      )
    def datastoreName: Optional[DatastoreName]
    def datastoreStorage
        : Optional[zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly]
    def status: Optional[zio.aws.iotanalytics.model.DatastoreStatus]
    def creationTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def lastMessageArrivalTime: Optional[Timestamp]
    def fileFormatType: Optional[zio.aws.iotanalytics.model.FileFormatType]
    def datastorePartitions
        : Optional[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly]
    def getDatastoreName: ZIO[Any, AwsError, DatastoreName] =
      AwsError.unwrapOptionField("datastoreName", datastoreName)
    def getDatastoreStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("datastoreStorage", datastoreStorage)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatastoreStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
    def getFileFormatType
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.FileFormatType] =
      AwsError.unwrapOptionField("fileFormatType", fileFormatType)
    def getDatastorePartitions: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly
    ] = AwsError.unwrapOptionField("datastorePartitions", datastorePartitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
  ) extends zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly {
    override val datastoreName: Optional[DatastoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.datastoreName())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreName(value))
    override val datastoreStorage: Optional[
      zio.aws.iotanalytics.model.DatastoreStorageSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datastoreStorage())
      .map(value =>
        zio.aws.iotanalytics.model.DatastoreStorageSummary.wrap(value)
      )
    override val status: Optional[zio.aws.iotanalytics.model.DatastoreStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotanalytics.model.DatastoreStatus.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMessageArrivalTime())
        .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val fileFormatType
        : Optional[zio.aws.iotanalytics.model.FileFormatType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormatType())
        .map(value => zio.aws.iotanalytics.model.FileFormatType.wrap(value))
    override val datastorePartitions
        : Optional[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datastorePartitions())
        .map(value =>
          zio.aws.iotanalytics.model.DatastorePartitions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary
  ): zio.aws.iotanalytics.model.DatastoreSummary.ReadOnly = new Wrapper(impl)
}
