package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.iotanalytics.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.TagResourceRequest.ReadOnly =
    zio.aws.iotanalytics.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.TagResourceRequest =
      zio.aws.iotanalytics.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.iotanalytics.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest
  ) extends zio.aws.iotanalytics.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.iotanalytics.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.iotanalytics.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.TagResourceRequest
  ): zio.aws.iotanalytics.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
