package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{RoleArn, S3KeyPrefix, BucketName}
import scala.jdk.CollectionConverters._
final case class CustomerManagedDatastoreS3StorageSummary(
    bucket: Optional[BucketName] = Optional.Absent,
    keyPrefix: Optional[S3KeyPrefix] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary = {
    import CustomerManagedDatastoreS3StorageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary.ReadOnly =
    zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
      .wrap(buildAwsValue())
}
object CustomerManagedDatastoreS3StorageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary =
      zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary(
        bucket.map(value => value),
        keyPrefix.map(value => value),
        roleArn.map(value => value)
      )
    def bucket: Optional[BucketName]
    def keyPrefix: Optional[S3KeyPrefix]
    def roleArn: Optional[RoleArn]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
  ) extends zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary.ReadOnly {
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.iotanalytics.model.primitives.BucketName(value))
    override val keyPrefix: Optional[S3KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefix())
      .map(value => zio.aws.iotanalytics.model.primitives.S3KeyPrefix(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iotanalytics.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary
  ): zio.aws.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary.ReadOnly =
    new Wrapper(impl)
}
