package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{DatastoreArn, DatastoreName}
import scala.jdk.CollectionConverters._
final case class CreateDatastoreResponse(
    datastoreName: Optional[DatastoreName] = Optional.Absent,
    datastoreArn: Optional[DatastoreArn] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse = {
    import CreateDatastoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse
      .builder()
      .optionallyWith(
        datastoreName.map(value =>
          DatastoreName.unwrap(value): java.lang.String
        )
      )(_.datastoreName)
      .optionallyWith(
        datastoreArn.map(value => DatastoreArn.unwrap(value): java.lang.String)
      )(_.datastoreArn)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly =
    zio.aws.iotanalytics.model.CreateDatastoreResponse.wrap(buildAwsValue())
}
object CreateDatastoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateDatastoreResponse =
      zio.aws.iotanalytics.model.CreateDatastoreResponse(
        datastoreName.map(value => value),
        datastoreArn.map(value => value),
        retentionPeriod.map(value => value.asEditable)
      )
    def datastoreName: Optional[DatastoreName]
    def datastoreArn: Optional[DatastoreArn]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def getDatastoreName: ZIO[Any, AwsError, DatastoreName] =
      AwsError.unwrapOptionField("datastoreName", datastoreName)
    def getDatastoreArn: ZIO[Any, AwsError, DatastoreArn] =
      AwsError.unwrapOptionField("datastoreArn", datastoreArn)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse
  ) extends zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly {
    override val datastoreName: Optional[DatastoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.datastoreName())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreName(value))
    override val datastoreArn: Optional[DatastoreArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datastoreArn())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreArn(value))
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatastoreResponse
  ): zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
