package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{
  RoleArn,
  BucketKeyExpression,
  BucketName
}
import scala.jdk.CollectionConverters._
final case class S3DestinationConfiguration(
    bucket: BucketName,
    key: BucketKeyExpression,
    glueConfiguration: Optional[zio.aws.iotanalytics.model.GlueConfiguration] =
      Optional.Absent,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.S3DestinationConfiguration = {
    import S3DestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.S3DestinationConfiguration
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(BucketKeyExpression.unwrap(key): java.lang.String)
      .optionallyWith(glueConfiguration.map(value => value.buildAwsValue()))(
        _.glueConfiguration
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.S3DestinationConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.S3DestinationConfiguration.wrap(buildAwsValue())
}
object S3DestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.S3DestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.S3DestinationConfiguration =
      zio.aws.iotanalytics.model.S3DestinationConfiguration(
        bucket,
        key,
        glueConfiguration.map(value => value.asEditable),
        roleArn
      )
    def bucket: BucketName
    def key: BucketKeyExpression
    def glueConfiguration
        : Optional[zio.aws.iotanalytics.model.GlueConfiguration.ReadOnly]
    def roleArn: RoleArn
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, BucketKeyExpression] = ZIO.succeed(key)
    def getGlueConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.GlueConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("glueConfiguration", glueConfiguration)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.S3DestinationConfiguration
  ) extends zio.aws.iotanalytics.model.S3DestinationConfiguration.ReadOnly {
    override val bucket: BucketName =
      zio.aws.iotanalytics.model.primitives.BucketName(impl.bucket())
    override val key: BucketKeyExpression =
      zio.aws.iotanalytics.model.primitives.BucketKeyExpression(impl.key())
    override val glueConfiguration
        : Optional[zio.aws.iotanalytics.model.GlueConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glueConfiguration())
        .map(value => zio.aws.iotanalytics.model.GlueConfiguration.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.iotanalytics.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.S3DestinationConfiguration
  ): zio.aws.iotanalytics.model.S3DestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
