package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait LoggingLevel {
  def unwrap: software.amazon.awssdk.services.iotanalytics.model.LoggingLevel
}
object LoggingLevel {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.LoggingLevel
  ): zio.aws.iotanalytics.model.LoggingLevel = value match {
    case software.amazon.awssdk.services.iotanalytics.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.LoggingLevel.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.LoggingLevel =
      software.amazon.awssdk.services.iotanalytics.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.iotanalytics.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.LoggingLevel =
      software.amazon.awssdk.services.iotanalytics.model.LoggingLevel.ERROR
  }
}
