package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{PresignedURI, EntryName}
import scala.jdk.CollectionConverters._
final case class DatasetEntry(
    entryName: Optional[EntryName] = Optional.Absent,
    dataURI: Optional[PresignedURI] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetEntry = {
    import DatasetEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetEntry
      .builder()
      .optionallyWith(
        entryName.map(value => EntryName.unwrap(value): java.lang.String)
      )(_.entryName)
      .optionallyWith(
        dataURI.map(value => PresignedURI.unwrap(value): java.lang.String)
      )(_.dataURI)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetEntry.ReadOnly =
    zio.aws.iotanalytics.model.DatasetEntry.wrap(buildAwsValue())
}
object DatasetEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetEntry =
      zio.aws.iotanalytics.model.DatasetEntry(
        entryName.map(value => value),
        dataURI.map(value => value)
      )
    def entryName: Optional[EntryName]
    def dataURI: Optional[PresignedURI]
    def getEntryName: ZIO[Any, AwsError, EntryName] =
      AwsError.unwrapOptionField("entryName", entryName)
    def getDataURI: ZIO[Any, AwsError, PresignedURI] =
      AwsError.unwrapOptionField("dataURI", dataURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetEntry
  ) extends zio.aws.iotanalytics.model.DatasetEntry.ReadOnly {
    override val entryName: Optional[EntryName] = zio.aws.core.internal
      .optionalFromNullable(impl.entryName())
      .map(value => zio.aws.iotanalytics.model.primitives.EntryName(value))
    override val dataURI: Optional[PresignedURI] = zio.aws.core.internal
      .optionalFromNullable(impl.dataURI())
      .map(value => zio.aws.iotanalytics.model.primitives.PresignedURI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetEntry
  ): zio.aws.iotanalytics.model.DatasetEntry.ReadOnly = new Wrapper(impl)
}
