package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iotanalytics.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListTagsForResourceRequest =
      zio.aws.iotanalytics.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest
  ) extends zio.aws.iotanalytics.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.iotanalytics.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListTagsForResourceRequest
  ): zio.aws.iotanalytics.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
