package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.PipelineName
import scala.jdk.CollectionConverters._
final case class DescribePipelineRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest = {
    import DescribePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribePipelineRequest.ReadOnly =
    zio.aws.iotanalytics.model.DescribePipelineRequest.wrap(buildAwsValue())
}
object DescribePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribePipelineRequest =
      zio.aws.iotanalytics.model.DescribePipelineRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest
  ) extends zio.aws.iotanalytics.model.DescribePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.iotanalytics.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribePipelineRequest
  ): zio.aws.iotanalytics.model.DescribePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
