package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.DatastoreName
import scala.jdk.CollectionConverters._
final case class DeleteDatastoreRequest(datastoreName: DatastoreName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest = {
    import DeleteDatastoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest
      .builder()
      .datastoreName(DatastoreName.unwrap(datastoreName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DeleteDatastoreRequest.ReadOnly =
    zio.aws.iotanalytics.model.DeleteDatastoreRequest.wrap(buildAwsValue())
}
object DeleteDatastoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DeleteDatastoreRequest =
      zio.aws.iotanalytics.model.DeleteDatastoreRequest(datastoreName)
    def datastoreName: DatastoreName
    def getDatastoreName: ZIO[Any, Nothing, DatastoreName] =
      ZIO.succeed(datastoreName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest
  ) extends zio.aws.iotanalytics.model.DeleteDatastoreRequest.ReadOnly {
    override val datastoreName: DatastoreName =
      zio.aws.iotanalytics.model.primitives.DatastoreName(impl.datastoreName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeleteDatastoreRequest
  ): zio.aws.iotanalytics.model.DeleteDatastoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
