package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{MaxVersions, UnlimitedVersioning}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VersioningConfiguration(
    unlimited: Optional[UnlimitedVersioning] = Optional.Absent,
    maxVersions: Optional[MaxVersions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration = {
    import VersioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
      .builder()
      .optionallyWith(
        unlimited.map(value =>
          UnlimitedVersioning.unwrap(value): java.lang.Boolean
        )
      )(_.unlimited)
      .optionallyWith(
        maxVersions.map(value => MaxVersions.unwrap(value): Integer)
      )(_.maxVersions)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.VersioningConfiguration.wrap(buildAwsValue())
}
object VersioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.VersioningConfiguration =
      zio.aws.iotanalytics.model.VersioningConfiguration(
        unlimited.map(value => value),
        maxVersions.map(value => value)
      )
    def unlimited: Optional[UnlimitedVersioning]
    def maxVersions: Optional[MaxVersions]
    def getUnlimited: ZIO[Any, AwsError, UnlimitedVersioning] =
      AwsError.unwrapOptionField("unlimited", unlimited)
    def getMaxVersions: ZIO[Any, AwsError, MaxVersions] =
      AwsError.unwrapOptionField("maxVersions", maxVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
  ) extends zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly {
    override val unlimited: Optional[UnlimitedVersioning] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unlimited())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.UnlimitedVersioning(value)
        )
    override val maxVersions: Optional[MaxVersions] = zio.aws.core.internal
      .optionalFromNullable(impl.maxVersions())
      .map(value => zio.aws.iotanalytics.model.primitives.MaxVersions(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration
  ): zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
