package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class TriggeringDataset(name: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.TriggeringDataset = {
    import TriggeringDataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.TriggeringDataset
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.TriggeringDataset.ReadOnly =
    zio.aws.iotanalytics.model.TriggeringDataset.wrap(buildAwsValue())
}
object TriggeringDataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.TriggeringDataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.TriggeringDataset =
      zio.aws.iotanalytics.model.TriggeringDataset(name)
    def name: DatasetName
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.TriggeringDataset
  ) extends zio.aws.iotanalytics.model.TriggeringDataset.ReadOnly {
    override val name: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.TriggeringDataset
  ): zio.aws.iotanalytics.model.TriggeringDataset.ReadOnly = new Wrapper(impl)
}
