package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{
  RoleArn,
  AttributeName,
  ActivityName
}
import scala.jdk.CollectionConverters._
final case class DeviceShadowEnrichActivity(
    name: ActivityName,
    attribute: AttributeName,
    thingName: AttributeName,
    roleArn: RoleArn,
    next: Optional[ActivityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeviceShadowEnrichActivity = {
    import DeviceShadowEnrichActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeviceShadowEnrichActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .attribute(AttributeName.unwrap(attribute): java.lang.String)
      .thingName(AttributeName.unwrap(thingName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly =
    zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.wrap(buildAwsValue())
}
object DeviceShadowEnrichActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeviceShadowEnrichActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DeviceShadowEnrichActivity =
      zio.aws.iotanalytics.model.DeviceShadowEnrichActivity(
        name,
        attribute,
        thingName,
        roleArn,
        next.map(value => value)
      )
    def name: ActivityName
    def attribute: AttributeName
    def thingName: AttributeName
    def roleArn: RoleArn
    def next: Optional[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getAttribute: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(attribute)
    def getThingName: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(thingName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeviceShadowEnrichActivity
  ) extends zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val attribute: AttributeName =
      zio.aws.iotanalytics.model.primitives.AttributeName(impl.attribute())
    override val thingName: AttributeName =
      zio.aws.iotanalytics.model.primitives.AttributeName(impl.thingName())
    override val roleArn: RoleArn =
      zio.aws.iotanalytics.model.primitives.RoleArn(impl.roleArn())
    override val next: Optional[ActivityName] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeviceShadowEnrichActivity
  ): zio.aws.iotanalytics.model.DeviceShadowEnrichActivity.ReadOnly =
    new Wrapper(impl)
}
