package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.ScheduleExpression
import scala.jdk.CollectionConverters._
final case class Schedule(
    expression: Optional[ScheduleExpression] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Schedule = {
    import Schedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Schedule
      .builder()
      .optionallyWith(
        expression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.expression)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Schedule.ReadOnly =
    zio.aws.iotanalytics.model.Schedule.wrap(buildAwsValue())
}
object Schedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Schedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Schedule =
      zio.aws.iotanalytics.model.Schedule(expression.map(value => value))
    def expression: Optional[ScheduleExpression]
    def getExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("expression", expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Schedule
  ) extends zio.aws.iotanalytics.model.Schedule.ReadOnly {
    override val expression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expression())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.ScheduleExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Schedule
  ): zio.aws.iotanalytics.model.Schedule.ReadOnly = new Wrapper(impl)
}
