package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait DatasetStatus {
  def unwrap: software.amazon.awssdk.services.iotanalytics.model.DatasetStatus
}
object DatasetStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.DatasetStatus
  ): zio.aws.iotanalytics.model.DatasetStatus = value match {
    case software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotanalytics.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.CREATING
  }
  case object ACTIVE extends zio.aws.iotanalytics.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.ACTIVE
  }
  case object DELETING extends zio.aws.iotanalytics.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.DatasetStatus =
      software.amazon.awssdk.services.iotanalytics.model.DatasetStatus.DELETING
  }
}
