package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{
  TimestampFormat,
  PartitionAttributeName
}
import scala.jdk.CollectionConverters._
final case class TimestampPartition(
    attributeName: PartitionAttributeName,
    timestampFormat: Optional[TimestampFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.TimestampPartition = {
    import TimestampPartition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.TimestampPartition
      .builder()
      .attributeName(
        PartitionAttributeName.unwrap(attributeName): java.lang.String
      )
      .optionallyWith(
        timestampFormat.map(value =>
          TimestampFormat.unwrap(value): java.lang.String
        )
      )(_.timestampFormat)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.TimestampPartition.ReadOnly =
    zio.aws.iotanalytics.model.TimestampPartition.wrap(buildAwsValue())
}
object TimestampPartition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.TimestampPartition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.TimestampPartition =
      zio.aws.iotanalytics.model
        .TimestampPartition(attributeName, timestampFormat.map(value => value))
    def attributeName: PartitionAttributeName
    def timestampFormat: Optional[TimestampFormat]
    def getAttributeName: ZIO[Any, Nothing, PartitionAttributeName] =
      ZIO.succeed(attributeName)
    def getTimestampFormat: ZIO[Any, AwsError, TimestampFormat] =
      AwsError.unwrapOptionField("timestampFormat", timestampFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.TimestampPartition
  ) extends zio.aws.iotanalytics.model.TimestampPartition.ReadOnly {
    override val attributeName: PartitionAttributeName =
      zio.aws.iotanalytics.model.primitives
        .PartitionAttributeName(impl.attributeName())
    override val timestampFormat: Optional[TimestampFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampFormat())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.TimestampFormat(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.TimestampPartition
  ): zio.aws.iotanalytics.model.TimestampPartition.ReadOnly = new Wrapper(impl)
}
