package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Tag.ReadOnly =
    zio.aws.iotanalytics.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotanalytics.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Tag =
      zio.aws.iotanalytics.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Tag
  ) extends zio.aws.iotanalytics.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.iotanalytics.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.iotanalytics.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Tag
  ): zio.aws.iotanalytics.model.Tag.ReadOnly = new Wrapper(impl)
}
