package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class CreateDatasetRequest(
    datasetName: DatasetName,
    actions: Iterable[zio.aws.iotanalytics.model.DatasetAction],
    triggers: Optional[Iterable[zio.aws.iotanalytics.model.DatasetTrigger]] =
      Optional.Absent,
    contentDeliveryRules: Optional[
      Iterable[zio.aws.iotanalytics.model.DatasetContentDeliveryRule]
    ] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent,
    versioningConfiguration: Optional[
      zio.aws.iotanalytics.model.VersioningConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotanalytics.model.Tag]] = Optional.Absent,
    lateDataRules: Optional[Iterable[zio.aws.iotanalytics.model.LateDataRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        contentDeliveryRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contentDeliveryRules)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        versioningConfiguration.map(value => value.buildAwsValue())
      )(_.versioningConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lateDataRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lateDataRules)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreateDatasetRequest.ReadOnly =
    zio.aws.iotanalytics.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateDatasetRequest =
      zio.aws.iotanalytics.model.CreateDatasetRequest(
        datasetName,
        actions.map { item =>
          item.asEditable
        },
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        contentDeliveryRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        retentionPeriod.map(value => value.asEditable),
        versioningConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lateDataRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetName: DatasetName
    def actions: List[zio.aws.iotanalytics.model.DatasetAction.ReadOnly]
    def triggers
        : Optional[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]]
    def contentDeliveryRules: Optional[
      List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly]
    ]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def versioningConfiguration
        : Optional[zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.iotanalytics.model.Tag.ReadOnly]]
    def lateDataRules
        : Optional[List[zio.aws.iotanalytics.model.LateDataRule.ReadOnly]]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.iotanalytics.model.DatasetAction.ReadOnly
    ]] = ZIO.succeed(actions)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getContentDeliveryRules: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("contentDeliveryRules", contentDeliveryRules)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getVersioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "versioningConfiguration",
      versioningConfiguration
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLateDataRules: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.LateDataRule.ReadOnly
    ]] = AwsError.unwrapOptionField("lateDataRules", lateDataRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest
  ) extends zio.aws.iotanalytics.model.CreateDatasetRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
    override val actions
        : List[zio.aws.iotanalytics.model.DatasetAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.DatasetAction.wrap(item)
      }
      .toList
    override val triggers
        : Optional[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetTrigger.wrap(item)
          }.toList
        )
    override val contentDeliveryRules: Optional[
      List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentDeliveryRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.DatasetContentDeliveryRule.wrap(item)
        }.toList
      )
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val versioningConfiguration: Optional[
      zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.versioningConfiguration())
      .map(value =>
        zio.aws.iotanalytics.model.VersioningConfiguration.wrap(value)
      )
    override val tags: Optional[List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.Tag.wrap(item)
          }.toList
        )
    override val lateDataRules
        : Optional[List[zio.aws.iotanalytics.model.LateDataRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lateDataRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.LateDataRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetRequest
  ): zio.aws.iotanalytics.model.CreateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
