package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{Timestamp, ChannelName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ChannelSummary(
    channelName: Optional[ChannelName] = Optional.Absent,
    channelStorage: Optional[zio.aws.iotanalytics.model.ChannelStorageSummary] =
      Optional.Absent,
    status: Optional[zio.aws.iotanalytics.model.ChannelStatus] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent,
    lastMessageArrivalTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ChannelSummary = {
    import ChannelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ChannelSummary
      .builder()
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(channelStorage.map(value => value.buildAwsValue()))(
        _.channelStorage
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ChannelSummary.ReadOnly =
    zio.aws.iotanalytics.model.ChannelSummary.wrap(buildAwsValue())
}
object ChannelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ChannelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ChannelSummary =
      zio.aws.iotanalytics.model.ChannelSummary(
        channelName.map(value => value),
        channelStorage.map(value => value.asEditable),
        status.map(value => value),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value)
      )
    def channelName: Optional[ChannelName]
    def channelStorage
        : Optional[zio.aws.iotanalytics.model.ChannelStorageSummary.ReadOnly]
    def status: Optional[zio.aws.iotanalytics.model.ChannelStatus]
    def creationTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def lastMessageArrivalTime: Optional[Timestamp]
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("channelStorage", channelStorage)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.ChannelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelSummary
  ) extends zio.aws.iotanalytics.model.ChannelSummary.ReadOnly {
    override val channelName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelName(value))
    override val channelStorage
        : Optional[zio.aws.iotanalytics.model.ChannelStorageSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelStorage())
        .map(value =>
          zio.aws.iotanalytics.model.ChannelStorageSummary.wrap(value)
        )
    override val status: Optional[zio.aws.iotanalytics.model.ChannelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotanalytics.model.ChannelStatus.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMessageArrivalTime())
        .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelSummary
  ): zio.aws.iotanalytics.model.ChannelSummary.ReadOnly = new Wrapper(impl)
}
